import argparse
import csv
import os
import matplotlib.pyplot as plt


def load_trace(path: str):
	with open(path, "r", encoding="utf-8") as fh:
		reader = csv.DictReader(fh)
		return [row for row in reader]


def main():
	parser = argparse.ArgumentParser()
	parser.add_argument("--trace", required=True)
	parser.add_argument("--out_reward", required=True)
	parser.add_argument("--out_pos", required=True)
	args = parser.parse_args()

	rows = load_trace(args.trace)
	rewards = [float(r["reward"]) for r in rows]
	pos = [float(r["norm_pos"]) for r in rows]

	os.makedirs(os.path.dirname(args.out_reward), exist_ok=True)
	plt.figure(figsize=(8, 3))
	plt.plot(rewards, linewidth=1.0)
	plt.title(os.path.basename(args.trace) + " — reward")
	plt.tight_layout()
	plt.savefig(args.out_reward, dpi=150)
	plt.close()

	plt.figure(figsize=(8, 3))
	plt.plot(pos, linewidth=1.0)
	plt.title(os.path.basename(args.trace) + " — norm_pos")
	plt.tight_layout()
	plt.savefig(args.out_pos, dpi=150)
	plt.close()


if __name__ == "__main__":
	main()


